/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class TableItem extends Item {
	Table parent;
	String [] strings;
	Object jsItem;
	
public TableItem (Table parent, int style) {
	this (parent, style, -1);
}

public TableItem (Table parent, int style, int index) {
	super (parent, style, index);
//FIXME TEMP "underscore" fix, until the Item constructor is "losing" the index in the constructor
	this._createWidget(this.display, parent, style, -1);	
}

protected void checkSubclass () {
}

//FIXME TEMP "underscore" fix, until the Item constructor is "losing" the index in the constructor
void _createWidget (Display display, Widget parent, int style, int index) {
	this.display = display;
	this.parent = (Table) parent;
	int newIndex = index;
	if (index==-1) { newIndex = this.parent.getItemCount();}
	this.parent.createItem (this, newIndex);
	hookEvents ();
	register ();
	text = "";
}

public Color getBackground () {
	return null;
}

public Color getBackground (int index) {
	return null;
}

public Rectangle getBounds () {
	return null;
}

public Rectangle getBounds (int index) {
	return null;
}

public boolean getChecked () {
	return false;
}

public Font getFont () {
	return null;
}

public Font getFont (int index) {
	return null;
}

public Color getForeground () {
	return null;
}

public Color getForeground (int index) {
	return null;
}

public boolean getGrayed () {
	return false;
}

public Image getImage () {
	return null;
}

public Image getImage (int index) {
	return null;
}

public Rectangle getImageBounds (int index) {
	return null;
}

public int getImageIndent () {
	return 0;
}

public Table getParent () {
	return null;
}

public String getText () {
	return "";
}

public String getText (int index) {
	return "";
}

public Rectangle getTextBounds (int index) {
	return null;
}

public void setBackground (Color color) {
}

public void setBackground (int index, Color color) {
}

public void setChecked (boolean checked) {
}

public void setFont (Font font) {
}

public void setFont (int index, Font font) {
}

public void setForeground (Color color) {
}

public void setForeground (int index, Color color) {
}

public void setGrayed (boolean grayed) {
}

public void setImage (Image[] images) {
	checkWidget ();
	if (images == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<images.length; i++) {
		setImage (i, images [i]);
	}
}

public void setImage (int index, Image image) {
	checkWidget ();
	if (image != null && image.isDisposed ()) {
		error(SWT.ERROR_INVALID_ARGUMENT);
	}
	if (image != null && image.type == SWT.ICON) {
	//	if (image.equals (_getImage (index))) return;
	}
	int count = Math.max (1, parent.getColumnCount ());
	if (0 > index || index > count - 1) return;
	Rectangle bounds = image.getBounds();
	String imageText = "<img src='" + image.imagePath +"'/>"; 
	_setText(index, imageText, parent.indexOf(this));
}

public void setImage (Image image) {
	checkWidget ();
	setImage (0, image);
}

public void setImageIndent (int indent) {
}

public void setText (String[] strings) {
	checkWidget();
	if (strings == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<strings.length; i++) {
		String string = strings [i];
		if (string != null) setText (i, string);
	}
}

public void setText (int index, String string) {
	checkWidget();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (index == 0) {
		if (string.equals (text)) return;
		super.setText (string);
	}
	int count = Math.max (1, parent.getColumnCount ());
	if (0 > index || index > count - 1) return;
//TODO check if this has to be done in J or JS side?	
//	if (strings == null && index != 0)  {
//		strings = new String [count];
//		strings [0] = text;
//	}
//	if (strings != null) {
//		if (string.equals (strings [index])) return;
//		strings [index] = string;
//	}
	_setText (index, string, parent.indexOf(this));
}

public void setText (String string) {
	checkWidget();
	setText (0, string);
}

/*---------------- NATIVE INTERFACE ----------------*/

protected native void _createItem (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.TableItem"]){
		$wnd.dojo._hasResource["org.eclipse.swt.TableItem"] = true;
		$wnd.dojo.provide("org.eclipse.swt.TableItem");
		
		$wnd.dojo.require("dijit._Widget");
	
		$wnd.dojo.declare("org.eclipse.swt.TableItem", $wnd.dijit._Widget, {
			parent: "",
			rowIndex: 0,
			postCreate: function(){
				this.inherited("postCreate",arguments); 
				this.rowIndex = this.parent.rowCount;				
			},
			setText: function(index, string){
				this.parent.model.setDatum(string, this.rowIndex, index);
				this.parent.views.render();
			}
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	params.parent = jsParent;
	var self = new $wnd.org.eclipse.swt.TableItem(params);
	try {
		var jsItem = this.@org.eclipse.swt.widgets.TableItem::jsItem = [];
		parent.@org.eclipse.swt.widgets.Table::jsItems.splice(index, 0, jsItem);
		parent.@org.eclipse.swt.widgets.Table::updateModel()();
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

//TODO implement
native int _getWidth () /*-{
//	var self = this.@org.eclipse.swt.widgets.Widget::jsObject;
//	width = $wnd.dojo.style(self.domNode,"width"); 
//	return width;
}-*/;

public native void _setText (int index, String string, int itemIndex) /*-{
	var parent = this.@org.eclipse.swt.widgets.TableItem::parent; 
	var model = parent.@org.eclipse.swt.widgets.Table::model;
	model.setDatum(string, itemIndex, index);
}-*/;

}
